"""
HB_ModelMode V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_ModelMode
Description-US: Enters Modelmode and does some other Settings (See Description)

This Script does following things:
1. Change mode to Model-mode
2. Show Axis if hidden
3. Activate Movetool
4. Disable Axis mode if enabled
5. Disable Xray Display

Name-DE: HB_ModelMode
Description-DE: Aktiviert Model Mode und macht ein paar andere Einstellungen

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=10m46s

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d

def main():
    drawBD = doc.GetActiveBaseDraw()
    drawBD[c4d.BASEDRAW_DATA_XRAY]=False
    
    
    
    c4d.CallCommand(12298) # Model
    c4d.CallCommand(200000088) # Move
    
    if (c4d.IsCommandChecked(12102)):
        c4d.CallCommand(12102)# Enable Axis
    
    if not (c4d.IsCommandChecked(1016176)):
        c4d.CallCommand(1016176) # Show Axis
        

if __name__=='__main__':
    main()
